Rem AdjustPageItems.vbs
Rem An InDesign VBScript
Rem
Rem Moves the content of even/odd pages by specified amounts; attempts to get
Rem objects back into the correct position after a master page margin change
Rem and/or page insertion.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem Or visit the InDesign Scripting User to User forum at http://www.adobeforums.com.
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2022")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll	
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.ActiveDocument.PageItems.Count <> 0 Then
	        myDisplayDialog myInDesign
	    End If
	End If
End Function
Function myDisplayDialog(myInDesign)
    myLabelWidth = 70
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.name = "Adjust Page Items"
    myPageNames = myGetPageNames(myInDesign.ActiveDocument)
    With myDialog.DialogColumns.Add
        With .BorderPanels.Add
            With .DialogColumns.Add
                With .DialogRows.Add
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = "Start Page:"
                            .MinWidth = myLabelWidth
                        End With
                    End With
                    With .DialogColumns.Add
                        Set myStartPageDropdown = .Dropdowns.Add
                        With myStartPageDropdown
                            .StringList = myPageNames
                            .selectedIndex = 0
                        End With
                    End With
                End With
                With .DialogRows.Add
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = "End Page:"
                            .MinWidth = myLabelWidth
                        End With
                    End With
                    With .DialogColumns.Add
                        Set myEndPageDropdown = .Dropdowns.Add
                        With myEndPageDropdown
                            .StringList = myPageNames
                            .selectedIndex = UBound(myPageNames)
                        End With
                    End With
                End With
            End With
        End With
        With .BorderPanels.Add
            With .DialogColumns.Add
                With .DialogRows.Add
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = "Even Pages"
                            .MinWidth = myLabelWidth
                        End With
                        With .StaticTexts.Add
                            .staticLabel = "Horizontal"
                            .MinWidth = myLabelWidth
                        End With
                        With .StaticTexts.Add
                            .staticLabel = "Vertical"
                            .MinWidth = myLabelWidth
                        End With
                    End With
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = ""
                        End With
                        Set myEvenXField = .MeasurementEditboxes.Add
                        With myEvenXField
                            .editValue = -12
                            .EditUnits = idMeasurementUnits.idPoints
                        End With
                        Set myEvenYField = .MeasurementEditboxes.Add
                        With myEvenYField
                            .editValue = 12
                            .EditUnits = idMeasurementUnits.idPoints
                        End With
                    End With
                End With
            End With
        End With
        With .BorderPanels.Add
            With .DialogColumns.Add
                With .DialogRows.Add
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = "Odd Pages"
                            .MinWidth = myLabelWidth
                        End With
                        With .StaticTexts.Add
                            .staticLabel = "Horizontal:"
                            .MinWidth = myLabelWidth
                        End With
                        With .StaticTexts.Add
                            .staticLabel = "Vertical:"
                            .MinWidth = myLabelWidth
                        End With
                    End With
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = ""
                        End With
                        Set myOddXField = .MeasurementEditboxes.Add
                        With myOddXField
                            .editValue = 12
                            .EditUnits = idMeasurementUnits.idPoints
                        End With
                        Set myOddYField = .MeasurementEditboxes.Add
                        With myOddYField
                            .editValue = 12
                            .EditUnits = idMeasurementUnits.idPoints
                        End With
                    End With
                End With
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
        myStartPageName = myPageNames(myStartPageDropdown.selectedIndex)
        myEndPageName = myPageNames(myEndPageDropdown.selectedIndex)
        If myCheckPageRange(myInDesign, myStartPageName, myEndPageName) = True Then
            myEvenX = myEvenXField.editValue
            myEvenY = myEvenYField.editValue
            myOddX = myOddXField.editValue
            myOddY = myOddYField.editValue
            myDialog.Destroy
            myAdjustPages myInDesign, myEvenX, myEvenY, myOddX, myOddY, myStartPageName, myEndPageName
        Else
            myDialog.Destroy
            MsgBox "Invalid page range."
        End If
    Else
        myDialog.Destroy
    End If
End Function
Function myCheckPageStart(myDocument)
    Set mySection = myDocument.Sections.Item(1)
    If mySection.ContinueNumbering = True Then
        Rem Starting page number is defined by other documents in the book
        myCheckPageStart = True
    End If
    If mySection.PageNumberStart Mod 2 = 0 Then
        Rem Starting page number is an even page.
        myCheckPageStart = False
    Else
        Rem Starting page number is an odd page.
        myCheckPageStart = True
    End If
End Function
Function myAdjustPages(myInDesign, myEvenX, myEvenY, myOddX, myOddY, myStartPageName, myEndPageName)
    myOldXUnits = myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits
    myOldYUnits = myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits
    Rem Set the measurement units to points.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = idMeasurementUnits.idPoints
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = idMeasurementUnits.idPoints
    Rem Save the old page numbering
    myOldPageNumbering = myInDesign.GeneralPreferences.PageNumbering
    myInDesign.GeneralPreferences.PageNumbering = idPageNumberingOptions.idSection
    Set myStartPage = myInDesign.ActiveDocument.Pages.Item(myStartPageName)
    Set myEndPage = myInDesign.ActiveDocument.Pages.Item(myEndPageName)
    Rem Set page numbering to absolute
    myInDesign.GeneralPreferences.PageNumbering = idPageNumberingOptions.idAbsolute
    Rem Does the page start with an even page?
    If myCheckPageStart(myInDesign.ActiveDocument) = False Then
        myPageAdjust = 1
    Else
        myPageAdjust = 0
    End If
    For myCounter = myStartPage.DocumentOffset To myEndPage.DocumentOffset
        Set myPage = myInDesign.ActiveDocument.Pages.Item(myCounter)
        If CInt(myPage.DocumentOffset + myPageAdjust) Mod 2 = 0 Then
            Rem Page is an even page.
            myAdjustPage myInDesign, myPage, myEvenX, myEvenY
        Else
            Rem Page is an odd page.
            myAdjustPage myInDesign, myPage, myOddX, myOddY
        End If
    Next
    Rem Reset the transform content and measurement units to their original values.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = myOldXUnits
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = myOldYUnits
    myInDesign.GeneralPreferences.PageNumbering = myOldPageNumbering
End Function

Function myAdjustPage(myInDesign, myPage, myX, myY)
    For myCounter = 1 To myPage.PageItems.Count
        myResetItemLock = False
        myResetLayerLock = False
        Set myPageItem = myPage.PageItems.Item(myCounter)
        If myPageItem.Locked = True Then
            myPageItem.Locked = False
            myResetItemLock = True
        End If
        If myPageItem.ItemLayer.Locked = True Then
            myPageItem.ItemLayer.Locked = False
            myResetLayerLock = True
        End If
        myPageItem.Move , Array(myX, myY)
        If myResetItemLock = True Then
            myPageItem.Locked = True
        End If
        If myResetLayerLock = True Then
            myPageItem.ItemLayer.Locked = True
        End If
    Next
End Function
Function myGetPageNames(myDocument)
    ReDim myPageNames(0)
    For myCounter = 1 To myDocument.Pages.Count
        If myCounter > 1 Then
            ReDim Preserve myPageNames(UBound(myPageNames) + 1)
        End If
        myPageNames(UBound(myPageNames)) = myDocument.Pages.Item(myCounter).name
    Next
    myGetPageNames = myPageNames
End Function
Function myCheckPageRange(myInDesign, myStartPageName, myEndPageName)
    myStartIndex = myInDesign.ActiveDocument.Pages.Item(myStartPageName).DocumentOffset
    myEndIndex = myInDesign.ActiveDocument.Pages.Item(myEndPageName).DocumentOffset
    If myStartIndex <= myEndIndex Then
        myCheckPageRange = True
    Else
        myCheckPageRange = False
    End If
End Function

'' SIG '' Begin signature block
'' SIG '' MIIhPgYJKoZIhvcNAQcCoIIhLzCCISsCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' Q1tszN/Z8qf17Ri6SPqrAkTTIg2lu4n6eYmigGA4Siig
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQCHK5i9aO5k82w+FiDw5C
'' SIG '' dzANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTIw
'' SIG '' MTIxOTAwMDAwMFoXDTIyMTIyMTIzNTk1OVowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKraHbKp
'' SIG '' 7LWhQb1eUijAwzznOPnL0ar6Bh5IyTX0X3Nmx0y/zOPp
'' SIG '' A769ixYCLdufIms+U9xBOpXey6jajunMtomUtqLHkYMN
'' SIG '' DT2jzWOCqLvnwrHjehFxLYwYIt9ymU0VqJHPcIO+0lfA
'' SIG '' s4ZoskzD5OepJsCVjURfwILDS/l51c42dKXqbPmr25vz
'' SIG '' UQBlKIg7JV7JJGj29DQMOeCI9LSY4dAUYsfaEfDx0dcb
'' SIG '' T/oDlUZAH/mGrvFonoqGwLDNNSpWkFauC3ryUlgMJ6if
'' SIG '' JX9iZIrdm6Glo/EvxbsHMzsL2TclgBXoa0mYq4PYgMH1
'' SIG '' 5XYNA9y4x7QNLRmWPpXU+4gnfN0CAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBS5nvze3WzR/65rffm/COInbJUTtzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEALl6DDJXB+ruS0J/n4zd6
'' SIG '' IxqKGcJnnn72tgm50zJjxjqD9f4gMlY5lFA4Dcz9D6ur
'' SIG '' Yc734LqeT9p+oUv2PI4KdFMpSmhdrKLkI8eTK46NHVW8
'' SIG '' U/GZctdsVZR1JvtI1ByrH/DkQS7HTKWwtbyOkKU7lfYK
'' SIG '' HIS+qUso64cM6M2asUym8CdN/3FbwJ9dGJDX9yfMISbX
'' SIG '' oIDfInSnVDD+Z9EnnpsEw9obZwNHaGdd1NJRuPrlwatk
'' SIG '' YdBJuo5kN5/eBMYb95FbK8zZf8e+5FTnEJ0PmxRakjlF
'' SIG '' xh5Zg3CCjiIjr3w/uUkOaa2PjpkNy/vuUYxCuJb53Ca6
'' SIG '' i+n/WMWWjYJLNDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCFAIwghP+AgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAhyuYvWjuZPNsPhYg8OQncw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIBPITHwaIuc3
'' SIG '' i7nKIoICZ9MBw+W1o1rit1PWF8nVoQZIMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAHhOfc3YG
'' SIG '' pjYuU8EjImxKQzE5CpFL1kSWUOPzZtyRbHt1RbesrlOY
'' SIG '' UbjTWyZTy7JUqL4gpvKfTUxjsrigii/sQC9aXKBpXHDq
'' SIG '' Rn5LFb0tOCWOghV3EM/TPBQO28MGlALcmrA/JWI43UMT
'' SIG '' Hp4OYkIh/jFyRCeapUmkUdDq9C3g3v8T8ZlIoVlBjt0s
'' SIG '' cYkEzjiKaezT577ecYkYwxWunA3svfrXvZrnZF/uqKrr
'' SIG '' z3geVUCvkA+ar3YtKhDssA2c6knSLpuq6qQdYJhq+9a7
'' SIG '' uncuhdXXRmFwtGPgQL7arJz0TxTX2TjgbAKh5fBTJ7x1
'' SIG '' veMsQv/tLcMgvB+Tmn2xPza2cqGCEbMwghGvBgorBgEE
'' SIG '' AYI3AwMBMYIRnzCCEZsGCSqGSIb3DQEHAqCCEYwwghGI
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCCs3fWFmYAjyvQfA+WFiqrfHGB62+BKLDXT
'' SIG '' iZLNVZwUnQIRAJHi+PYHhsGEZqpt5AlrkQQYDzIwMjIw
'' SIG '' NDE4MTkwMzA0WqCCDXwwggbGMIIErqADAgECAhAKekqI
'' SIG '' nsmZQpAGYzhNhpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJ
'' SIG '' BgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
'' SIG '' LjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBS
'' SIG '' U0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcN
'' SIG '' MjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
'' SIG '' CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIElu
'' SIG '' Yy4xJDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAy
'' SIG '' MDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
'' SIG '' AgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
'' SIG '' 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFEN
'' SIG '' MQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJxbKFiJgHT
'' SIG '' zsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIj
'' SIG '' QVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRS
'' SIG '' Xw9Q3tRZLER0wDJHGVvimC6P0Mo//8ZnzzyTlU6E6XYY
'' SIG '' mJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz
'' SIG '' 4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2u
'' SIG '' fyguwp7gC0vICNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5w
'' SIG '' LOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03Sh
'' SIG '' L7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHX
'' SIG '' L537/M2xwafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP
'' SIG '' 6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
'' SIG '' CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tL
'' SIG '' suK2QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqY
'' SIG '' klHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGjggGL
'' SIG '' MIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
'' SIG '' ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAE
'' SIG '' GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYDVR0j
'' SIG '' BBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0O
'' SIG '' BBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRT
'' SIG '' MFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
'' SIG '' aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGD
'' SIG '' MIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdp
'' SIG '' Y2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNl
'' SIG '' cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRH
'' SIG '' NFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQw
'' SIG '' DQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
'' SIG '' 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76T
'' SIG '' Ot4qOVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7f
'' SIG '' IyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJT4LW
'' SIG '' pXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
'' SIG '' y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZb
'' SIG '' NZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEiptucdYL0E
'' SIG '' IhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSi
'' SIG '' ZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBV
'' SIG '' eNaY/lRtf3GpSBp43UZ3Lht6wDOK+EoojBKoc88t+dMj
'' SIG '' 8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q
'' SIG '' +A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW0
'' SIG '' 5rUMopml1xVrNQ6F1uAszOAMJLh8UgsemXzvyMjFjFhp
'' SIG '' r6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/T
'' SIG '' f8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zM
'' SIG '' bbUNrkdjOEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3
'' SIG '' AhMcMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipe
'' SIG '' WzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAwMDAw
'' SIG '' WhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMT
'' SIG '' MkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEy
'' SIG '' NTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
'' SIG '' AQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUD
'' SIG '' xPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo
'' SIG '' +n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITaEfFz
'' SIG '' sbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1Oco
'' SIG '' LevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald6
'' SIG '' 8Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7QKxf
'' SIG '' st5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRAp8By
'' SIG '' xbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWH
'' SIG '' po9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgRs/b2
'' SIG '' nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKVEStY
'' SIG '' dEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/
'' SIG '' 8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1CvwWc
'' SIG '' ZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHek/45
'' SIG '' wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKo
'' SIG '' wSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXi
'' SIG '' YKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM0jO0
'' SIG '' zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8C
'' SIG '' AQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshv
'' SIG '' MB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiuHA9P
'' SIG '' MA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
'' SIG '' BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGG
'' SIG '' GGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggrBgEF
'' SIG '' BQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29t
'' SIG '' L0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0f
'' SIG '' BDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmwwIAYD
'' SIG '' VR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0G
'' SIG '' CSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+ZtbY
'' SIG '' IULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8acHP
'' SIG '' HQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwI
'' SIG '' gqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6q4XN
'' SIG '' Q1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAKfO+o
'' SIG '' vHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSu
'' SIG '' mScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7
'' SIG '' pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR8XKc
'' SIG '' 6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbD
'' SIG '' Qc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6um
'' SIG '' AU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0dKNPH
'' SIG '' +ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm8heZ
'' SIG '' Wcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVB
'' SIG '' tzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8EifAA
'' SIG '' zV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP/JiW
'' SIG '' 9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8
'' SIG '' /DGCA3YwggNyAgEBMHcwYzELMAkGA1UEBhMCVVMxFzAV
'' SIG '' BgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
'' SIG '' aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2
'' SIG '' IFRpbWVTdGFtcGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaX
'' SIG '' nTANBglghkgBZQMEAgEFAKCB0TAaBgkqhkiG9w0BCQMx
'' SIG '' DQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTIy
'' SIG '' MDQxODE5MDMwNFowKwYLKoZIhvcNAQkQAgwxHDAaMBgw
'' SIG '' FgQUhQjzhlFcs9MHfba0t8B/G0peQd4wLwYJKoZIhvcN
'' SIG '' AQkEMSIEIBOc4It9Z/GZfJC76hxjMm5nBnV4bEaYL7St
'' SIG '' iKVwaw0+MDcGCyqGSIb3DQEJEAIvMSgwJjAkMCIEIJ2m
'' SIG '' kBXDScbBiXhFujWCrXDIj6QpO9tqvpwr0lOSeeY7MA0G
'' SIG '' CSqGSIb3DQEBAQUABIICAAq53wa1xoOiCUkY3zdy3LJe
'' SIG '' UOHCVyVG96YV7KZYbto4goKB1OZg7PzTgEosh8fWTS+w
'' SIG '' tUh1D9THwHkqFxSvuqGjuqavwUleN446BeWwGZTVu+F1
'' SIG '' JmZM3hh783VKGroeLOt0cH9VuKoVQjCNF1UBG4nEyGUx
'' SIG '' IoN+yhA5/z4uYzAB55RFx7KX1Zr56qPMZOMSDxZUAe7D
'' SIG '' ZBc3Ggagc87KyAFt/L7VwJgIN8RqSEhDn+AZ1AG4D6TQ
'' SIG '' dk6zf8kxXVauWCbAa63hbauyF2YP0044vHncq21yqmQH
'' SIG '' JvLu+zYkh7SGV/8MPxXEVHd2WUm738htQC7/UXD1TOFU
'' SIG '' thI1c6XJHe3yEpEbpbtkzg80kVYFAytDR4UDRfDh9ex7
'' SIG '' 63o4QDbsVpIUAql6hXalWD00sJU9GQFkJA3T3zTF7zBg
'' SIG '' VxVPBVjjwdZNO9hV3Thuie2oq9LNJ1fUDRfSO9MUedO7
'' SIG '' JC5x7J4EGelCQ6wyVpdaBmuqMoM388R3hSfxmUyTY/lh
'' SIG '' Dg/JPGjDtzloLJSev3xsgv8sdVzd0w6v2VVMMsyITByy
'' SIG '' bg2Q/+MMqFHXLIZTWGm8m0oPzbo2NUF2rSa07la3P/yQ
'' SIG '' iiFRDWYeWp+10LDF59TfjEArKSikV3f1p1omTAdl9fx9
'' SIG '' umq7UAAwXvtSqlTPuy++y11K8r6if1Xku1GxGJkYrTYh
'' SIG '' End signature block
